/*
 * Decompiled with CFR 0.152.
 */
package weka.clusterers;

import java.io.IOException;
import junit.framework.TestCase;
import weka.clusterers.AbstractClusterer;
import weka.clusterers.CheckClusterer;
import weka.clusterers.Clusterer;
import weka.core.CheckGOE;
import weka.core.CheckOptionHandler;
import weka.core.Instances;
import weka.core.OptionHandler;
import weka.test.Regression;

public abstract class AbstractClustererTest
extends TestCase {
    protected Clusterer m_Clusterer;
    protected CheckClusterer m_Tester;
    protected boolean m_updateableClusterer;
    protected boolean m_weightedInstancesHandler;
    protected boolean m_multiInstanceHandler;
    protected boolean DEBUG = false;
    protected boolean m_NominalPredictors;
    protected boolean m_NumericPredictors;
    protected boolean m_StringPredictors;
    protected boolean m_DatePredictors;
    protected boolean m_RelationalPredictors;
    protected boolean m_handleMissingPredictors;
    protected String m_RegressionResults;
    protected CheckOptionHandler m_OptionTester;
    protected CheckGOE m_GOETester;

    public AbstractClustererTest(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        this.m_Clusterer = this.getClusterer();
        this.m_Tester = new CheckClusterer();
        this.m_Tester.setSilent(true);
        this.m_Tester.setClusterer(this.m_Clusterer);
        this.m_Tester.setNumInstances(20);
        this.m_Tester.setDebug(this.DEBUG);
        this.m_OptionTester = this.getOptionTester();
        this.m_GOETester = this.getGOETester();
        this.m_updateableClusterer = this.m_Tester.updateableClusterer()[0];
        this.m_weightedInstancesHandler = this.m_Tester.weightedInstancesHandler()[0];
        this.m_multiInstanceHandler = this.m_Tester.multiInstanceHandler()[0];
        this.m_NominalPredictors = false;
        this.m_NumericPredictors = false;
        this.m_StringPredictors = false;
        this.m_DatePredictors = false;
        this.m_RelationalPredictors = false;
        this.m_handleMissingPredictors = false;
        this.m_RegressionResults = "";
        this.checkAttributes(true, false, false, false, false, false);
        this.checkAttributes(false, true, false, false, false, false);
        this.checkAttributes(false, false, true, false, false, false);
        this.checkAttributes(false, false, false, true, false, false);
        this.checkAttributes(false, false, false, false, true, false);
        this.m_handleMissingPredictors = this.checkMissingPredictors(20, false);
    }

    @Override
    protected void tearDown() {
        this.m_Clusterer = null;
        this.m_Tester = null;
        this.m_OptionTester = null;
        this.m_GOETester = null;
        this.m_updateableClusterer = false;
        this.m_weightedInstancesHandler = false;
        this.m_NominalPredictors = false;
        this.m_NumericPredictors = false;
        this.m_StringPredictors = false;
        this.m_DatePredictors = false;
        this.m_RelationalPredictors = false;
        this.m_handleMissingPredictors = false;
        this.m_RegressionResults = "";
    }

    protected CheckOptionHandler getOptionTester() {
        CheckOptionHandler result = new CheckOptionHandler();
        if (this.getClusterer() instanceof OptionHandler) {
            result.setOptionHandler((OptionHandler)((Object)this.getClusterer()));
        } else {
            result.setOptionHandler(null);
        }
        result.setUserOptions(new String[0]);
        result.setSilent(true);
        return result;
    }

    protected CheckGOE getGOETester() {
        CheckGOE result = new CheckGOE();
        result.setObject(this.getClusterer());
        result.setSilent(true);
        return result;
    }

    public abstract Clusterer getClusterer();

    protected boolean canPredict() {
        return this.m_NominalPredictors || this.m_NumericPredictors || this.m_StringPredictors || this.m_DatePredictors || this.m_RelationalPredictors;
    }

    protected void checkAttributes(boolean nom, boolean num, boolean str, boolean dat, boolean rel, boolean allowFail) {
        String att = "";
        if (nom) {
            att = "nominal";
        } else if (num) {
            att = "numeric";
        } else if (str) {
            att = "string";
        } else if (dat) {
            att = "date";
        } else if (rel) {
            att = "relational";
        }
        boolean[] result = this.m_Tester.canPredict(nom, num, str, dat, rel, this.m_multiInstanceHandler);
        if (nom) {
            this.m_NominalPredictors = result[0];
        } else if (num) {
            this.m_NumericPredictors = result[0];
        } else if (str) {
            this.m_StringPredictors = result[0];
        } else if (dat) {
            this.m_DatePredictors = result[0];
        } else if (rel) {
            this.m_RelationalPredictors = result[0];
        }
        if (!result[0] && !result[1] && allowFail) {
            AbstractClustererTest.fail("Error handling " + att + " attributes!");
        }
    }

    public void testAttributes() {
        this.checkAttributes(true, false, false, false, false, true);
        this.checkAttributes(false, true, false, false, false, true);
        this.checkAttributes(false, false, true, false, false, true);
        this.checkAttributes(false, false, false, true, false, true);
        if (!this.m_multiInstanceHandler) {
            this.checkAttributes(false, false, false, false, true, true);
        }
    }

    public void testSerialVersionUID() {
        boolean[] result = this.m_Tester.declaresSerialVersionUID();
        if (!result[0]) {
            AbstractClustererTest.fail("Doesn't declare serialVersionUID!");
        }
    }

    public void testInstanceWeights() {
        if (this.m_weightedInstancesHandler) {
            if (!this.canPredict()) {
                return;
            }
            boolean[] result = this.m_Tester.instanceWeights(this.m_NominalPredictors, this.m_NumericPredictors, this.m_StringPredictors, this.m_DatePredictors, this.m_RelationalPredictors, this.m_multiInstanceHandler);
            if (!result[0]) {
                System.err.println("Error handling instance weights!");
            }
        }
    }

    public void testZeroTraining() {
        if (!this.canPredict()) {
            return;
        }
        boolean[] result = this.m_Tester.canHandleZeroTraining(this.m_NominalPredictors, this.m_NumericPredictors, this.m_StringPredictors, this.m_DatePredictors, this.m_RelationalPredictors, this.m_multiInstanceHandler);
        if (!result[0] && !result[1]) {
            AbstractClustererTest.fail("Error handling zero training instances!");
        }
    }

    protected boolean checkMissingPredictors(int percent, boolean allowFail) {
        boolean[] result = this.m_Tester.canHandleMissing(this.m_NominalPredictors, this.m_NumericPredictors, this.m_StringPredictors, this.m_DatePredictors, this.m_RelationalPredictors, this.m_multiInstanceHandler, true, percent);
        if (allowFail && !result[0] && !result[1]) {
            AbstractClustererTest.fail("Error handling " + percent + "% missing predictors!");
        }
        return result[0];
    }

    public void testMissingPredictors() {
        if (!this.canPredict()) {
            return;
        }
        this.checkMissingPredictors(20, true);
        if (this.m_handleMissingPredictors) {
            this.checkMissingPredictors(100, true);
        }
    }

    public void testBuildInitialization() {
        if (!this.canPredict()) {
            return;
        }
        boolean[] result = this.m_Tester.correctBuildInitialisation(this.m_NominalPredictors, this.m_NumericPredictors, this.m_StringPredictors, this.m_DatePredictors, this.m_RelationalPredictors, this.m_multiInstanceHandler);
        if (!result[0] && !result[1]) {
            AbstractClustererTest.fail("Incorrect build initialization!");
        }
    }

    public void testDatasetIntegrity() {
        if (!this.canPredict()) {
            return;
        }
        boolean[] result = this.m_Tester.datasetIntegrity(this.m_NominalPredictors, this.m_NumericPredictors, this.m_StringPredictors, this.m_DatePredictors, this.m_RelationalPredictors, this.m_multiInstanceHandler, this.m_handleMissingPredictors);
        if (!result[0] && !result[1]) {
            AbstractClustererTest.fail("Training set is altered during training!");
        }
    }

    public void testUpdatingEquality() {
        boolean[] result;
        if (this.m_updateableClusterer && !(result = this.m_Tester.updatingEquality(this.m_NominalPredictors, this.m_NumericPredictors, this.m_StringPredictors, this.m_DatePredictors, this.m_RelationalPredictors, this.m_multiInstanceHandler))[0]) {
            System.err.println("Incremental training does not produce same result as batch training!");
        }
    }

    protected String useClusterer(Instances data) throws Exception {
        Clusterer clusterer;
        try {
            clusterer = AbstractClusterer.makeCopy(this.m_Clusterer);
        }
        catch (Exception e) {
            clusterer = null;
            e.printStackTrace();
            AbstractClustererTest.fail("Problem setting up to use Clusterer: " + e);
        }
        clusterer.buildClusterer(data);
        String result = "";
        int i = 0;
        while (i < data.numInstances()) {
            if (i > 0) {
                result = String.valueOf(result) + "\n";
            }
            try {
                double cluster = clusterer.clusterInstance(data.instance(i));
                result = String.valueOf(result) + (i + 1) + ": " + cluster;
            }
            catch (Exception e) {
                result = String.valueOf(result) + (i + 1) + ": " + e.toString();
            }
            ++i;
        }
        return result;
    }

    public void testRegression() throws Exception {
        if (this.m_Tester.hasClasspathProblems()) {
            return;
        }
        Regression reg = new Regression(this.getClass());
        Instances train = null;
        boolean succeeded = false;
        train = this.m_Tester.makeTestDataset(42, this.m_Tester.getNumInstances(), this.m_NominalPredictors ? 2 : 0, this.m_NumericPredictors ? 1 : 0, this.m_StringPredictors ? 1 : 0, this.m_DatePredictors ? 1 : 0, this.m_RelationalPredictors ? 1 : 0, this.m_multiInstanceHandler);
        try {
            this.m_RegressionResults = this.useClusterer(train);
            succeeded = true;
            reg.println(this.m_RegressionResults);
        }
        catch (Exception e) {
            String msg = e.getMessage().toLowerCase();
            if (msg.indexOf("not in classpath") > -1) {
                return;
            }
            this.m_RegressionResults = null;
        }
        if (!succeeded) {
            AbstractClustererTest.fail("Problem during regression testing: no successful output generated");
        }
        try {
            String diff = reg.diff();
            if (diff == null) {
                System.err.println("Warning: No reference available, creating.");
            } else if (!diff.equals("")) {
                AbstractClustererTest.fail("Regression test failed. Difference:\n" + diff);
            }
        }
        catch (IOException ex) {
            AbstractClustererTest.fail("Problem during regression testing.\n" + ex);
        }
    }

    public void testListOptions() {
        if (this.m_OptionTester.getOptionHandler() != null && !this.m_OptionTester.checkListOptions()) {
            AbstractClustererTest.fail("Options cannot be listed via listOptions.");
        }
    }

    public void testSetOptions() {
        if (this.m_OptionTester.getOptionHandler() != null && !this.m_OptionTester.checkSetOptions()) {
            AbstractClustererTest.fail("setOptions method failed.");
        }
    }

    public void testDefaultOptions() {
        if (this.m_OptionTester.getOptionHandler() != null && !this.m_OptionTester.checkDefaultOptions()) {
            AbstractClustererTest.fail("Default options were not processed correctly.");
        }
    }

    public void testRemainingOptions() {
        if (this.m_OptionTester.getOptionHandler() != null && !this.m_OptionTester.checkRemainingOptions()) {
            AbstractClustererTest.fail("There were 'left-over' options.");
        }
    }

    public void testCanonicalUserOptions() {
        if (this.m_OptionTester.getOptionHandler() != null && !this.m_OptionTester.checkCanonicalUserOptions()) {
            AbstractClustererTest.fail("setOptions method failed");
        }
    }

    public void testResettingOptions() {
        if (this.m_OptionTester.getOptionHandler() != null && !this.m_OptionTester.checkSetOptions()) {
            AbstractClustererTest.fail("Resetting of options failed");
        }
    }

    public void testGlobalInfo() {
        if (!this.m_GOETester.checkGlobalInfo()) {
            AbstractClustererTest.fail("No globalInfo method");
        }
    }

    public void testToolTips() {
        if (!this.m_GOETester.checkToolTips()) {
            AbstractClustererTest.fail("Tool tips inconsistent");
        }
    }
}

